unit SelectForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, pub;

type
  TfrmSelectForm = class(TForm)
    lblForm: TLabel;
    cbForm: TComboBox;
    btnShow: TButton;
    btnCancel: TButton;
    procedure cbFormClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmSelectForm: TfrmSelectForm;

implementation

{$R *.DFM}

procedure TfrmSelectForm.cbFormClick(Sender: TObject);
begin
   if cbForm.ItemIndex > -1 then
      btnShow.Enabled := TRUE;
end;

procedure TfrmSelectForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure TfrmSelectForm.FormShow(Sender: TObject);
var sl : TStringList;
begin
   sl := TStringList.Create;
   try
      sl.Clear;
      pub.GetFiles('cuf','.',sl,FALSE);
      cbForm.Items.AddStrings(sl);
   finally
      sl.Free;
   end;
end;

procedure TfrmSelectForm.btnCancelClick(Sender: TObject);
begin
   Close;
end;

end.
